/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.skills.core;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.common.skills.core.DisplayType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class DisplayData {
    private final DisplayType<?> type;
    private final Object data;

    public static <D> DisplayData create(DisplayType<D> type, D data) {
        return new DisplayData(type, data);
    }

    @OnlyIn(value=Dist.CLIENT)
    public <D> void renderAt(MatrixStack stack, int x, int y) {
        DisplayType.IRenderFactory<?> factory = this.type.getRenderFactory();
        D data = this.getRenderData();
        factory.render(stack, x, y, data);
    }

    public <D> D getRenderData() {
        return (D)this.data;
    }

    private DisplayData(DisplayType<?> type, Object data) {
        this.type = type;
        this.data = data;
    }
}

